/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.crops.handlers;

import ic2.api.crops.CropCard;
import ic2.api.item.IC2Items;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import speiger.src.crops.IC2NeiPlugin;
import speiger.src.crops.api.ICropInfo;

public class ExpInfoLoader
implements ICropInfo {
    public Map<String, ItemStack> data;

    @Override
    public List<CropCard> getSupportedCrops() {
        return IC2NeiPlugin.ALL_CROPS;
    }

    @Override
    public List<String> getCropInformation(CropCard card) {
        ArrayList<String> result = new ArrayList<String>();
        String name = card.name();
        if (name.equals("wheat") || name.equals("coffee") || name.equals("hops")) {
            result.addAll(this.translateToLocalFormatted("info.requiresLight.name", "+9"));
        } else if (name.equals("potato") || name.equals("carrots") || name.equals("dandelion") || name.equals("rose") || name.equals("blackthorn") || name.equals("tulip") || name.equals("cyazint") || name.equals("venomilia")) {
            result.addAll(this.translateToLocalFormatted("info.requiresLight.name", "+12"));
        } else if (name.equals("cocoa")) {
            result.addAll(this.translateToLocalFormatted("info.requiresNutrient.name", "+3"));
        } else if (name.equals("ferru")) {
            result.addAll(this.translateToLocalFormatted("info.requiresSoilBlock.name", new ItemStack(Blocks.field_150366_p).func_82833_r()));
            result.addAll(this.translateToLocalFormatted("info.requiresSoilBlockExtension.name", new ItemStack(Blocks.field_150339_S).func_82833_r()));
        } else if (name.equals("aurelia")) {
            result.addAll(this.translateToLocalFormatted("info.requiresSoilBlock.name", new ItemStack(Blocks.field_150352_o).func_82833_r()));
            result.addAll(this.translateToLocalFormatted("info.requiresSoilBlockExtension.name", new ItemStack(Blocks.field_150340_R).func_82833_r()));
        } else if (name.equals("redwheat")) {
            result.addAll(this.translateToLocalFormatted("info.requiresSpecialLight.name", "5", "10"));
        } else if (name.equals("redMushroom") || name.equals("brownMushroom")) {
            result.addAll(this.translateToLocalFormatted("info.requiresHydration.name", "1"));
        } else if (name.equals("eatingplant")) {
            result.addAll(this.translateToLocalFormatted("info.requiresLight.name", "+11"));
            result.addAll(this.translateToLocalFormatted("info.requiresSoilBlock.name", new ItemStack(Blocks.field_150353_l).func_82833_r()));
            result.addAll(this.translateToLocal("expInfo.eatingPlant.name"));
        } else if (name.equals("cyprium")) {
            result.addAll(this.translateToLocalFormatted("info.requiresSoilBlock.name", IC2Items.getItem((String)"copperOre").func_82833_r()));
            result.addAll(this.translateToLocalFormatted("info.requiresSoilBlockExtension.name", IC2Items.getItem((String)"copperBlock").func_82833_r()));
        } else if (name.equals("plumbiscus")) {
            result.addAll(this.translateToLocalFormatted("info.requiresSoilBlock.name", IC2Items.getItem((String)"leadOre").func_82833_r()));
            result.addAll(this.translateToLocalFormatted("info.requiresSoilBlockExtension.name", IC2Items.getItem((String)"leadBlock").func_82833_r()));
        } else if (name.equals("stagnium")) {
            result.addAll(this.translateToLocalFormatted("info.requiresSoilBlock.name", IC2Items.getItem((String)"tinOre").func_82833_r()));
            result.addAll(this.translateToLocalFormatted("info.requiresSoilBlockExtension.name", IC2Items.getItem((String)"tinBlock").func_82833_r()));
        }
        return result;
    }

    public List<String> translateToLocal(String par1) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Arrays.asList(StatCollector.func_74838_a((String)par1).split("%n ")));
        return result;
    }

    public List<String> translateToLocalFormatted(String par1, Object ... par2) {
        String[] array;
        ArrayList<String> result = new ArrayList<String>();
        String text = StatCollector.func_74838_a((String)par1);
        for (String current : array = text.split("%n ")) {
            try {
                result.add(String.format(current, par2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public ItemStack getDisplayItems(CropCard card) {
        if (this.data == null) {
            this.load();
        }
        return this.data.get(card.name());
    }

    void load() {
        this.data = new HashMap<String, ItemStack>();
        this.data.put("wheat", new ItemStack(Items.field_151015_O));
        this.data.put("coffee", IC2Items.getItem((String)"coffeePowder").func_77946_l());
        this.data.put("hops", IC2Items.getItem((String)"hops").func_77946_l());
        this.data.put("potato", new ItemStack(Items.field_151174_bG));
        this.data.put("carrots", new ItemStack(Items.field_151172_bF));
        this.data.put("dandelion", new ItemStack(Items.field_151100_aR, 1, 11));
        this.data.put("rose", new ItemStack(Items.field_151100_aR, 1, 1));
        this.data.put("blackthorn", new ItemStack(Items.field_151100_aR, 1, 0));
        this.data.put("tulip", new ItemStack(Items.field_151100_aR, 1, 5));
        this.data.put("cyazint", new ItemStack(Items.field_151100_aR, 1, 6));
        this.data.put("venomilia", new ItemStack(Items.field_151100_aR, 1, 5));
        this.data.put("reed", new ItemStack(Items.field_151120_aE));
        this.data.put("stickreed", IC2Items.getItem((String)"resin").func_77946_l());
        this.data.put("cocoa", new ItemStack(Items.field_151100_aR, 1, 3));
        this.data.put("ferru", new ItemStack(Items.field_151042_j));
        this.data.put("aurelia", new ItemStack(Items.field_151043_k));
        this.data.put("redwheat", new ItemStack(Items.field_151137_ax));
        this.data.put("redMushroom", new ItemStack((Block)Blocks.field_150337_Q));
        this.data.put("brownMushroom", new ItemStack((Block)Blocks.field_150338_P));
        this.data.put("netherWart", new ItemStack(Items.field_151075_bm));
        this.data.put("terraWart", IC2Items.getItem((String)"terraWart"));
        this.data.put("pumpkin", new ItemStack(Blocks.field_150423_aK));
        this.data.put("melon", new ItemStack(Items.field_151127_ba));
        this.data.put("weed", IC2Items.getItem((String)"weed"));
        this.data.put("eatingplant", new ItemStack(Blocks.field_150434_aF));
        this.data.put("cyprium", IC2Items.getItem((String)"smallCopperDust"));
        this.data.put("plumbiscus", IC2Items.getItem((String)"smallLeadDust"));
        this.data.put("shining", IC2Items.getItem((String)"smallSilverDust"));
        this.data.put("stagnium", IC2Items.getItem((String)"smallTinDust"));
    }
}

